<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Beta 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager'))
{
	exit;
}

/**
* @package	vBulletin
* @version	$Revision: 25445 $
* @date		$Date: 2008-01-15 10:17:58 -0600 (Tue, 15 Jan 2008) $
*/
class vB_DataManager_Picture extends vB_DataManager
{

	/**
	* Array of recognized and required fields for avatar inserts
	*
	* @var	array
	*/
	var $validfields = array(
		'pictureid'          => array(TYPE_UINT,       REQ_INCR),
		'userid'             => array(TYPE_UINT,       REQ_YES),
		'caption'            => array(TYPE_NOHTMLCOND, REQ_NO),
		'extension'          => array(TYPE_NOHTMLCOND, REQ_YES,  VF_METHOD),
		'filedata'           => array(TYPE_BINARY,     REQ_NO,   VF_METHOD),
		'filesize'           => array(TYPE_UINT,       REQ_YES),
		'width'              => array(TYPE_UINT,       REQ_NO),
		'height'             => array(TYPE_UINT,       REQ_NO),
		'thumbnail'          => array(TYPE_BINARY,     REQ_NO,   VF_METHOD),
		'thumbnail_dateline' => array(TYPE_UINT,       REQ_NO),
		'thumbnail_filesize' => array(TYPE_UINT,       REQ_NO),
		'thumbnail_width'    => array(TYPE_UINT,       REQ_NO),
		'thumbnail_height'   => array(TYPE_UINT,       REQ_NO),
		'idhash'             => array(TYPE_STR,        REQ_AUTO)
	);

	/**
	*
	* @var	string  The main table this class deals with
	*/
	var $table = 'picture';

	/**
	* Arrays to store stuff to save to picture-related tables
	*
	* @var	array
	*/
	var $picture = array();

	var $info = array(
		'albums' => array(),
		'dateline' => 0,
		'auto_count_update' => true,
		'have_updated_usercss' => false
	);

	/**
	* Condition template for update query
	* This is for use with sprintf(). First key is the where clause, further keys are the field names of the data to be used.
	*
	* @var	array
	*/
	var $condition_construct = array('pictureid = %1$d', 'pictureid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vB_DataManager_Picture(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		if (!is_subclass_of($this, 'vB_DataManager_Picture'))
		{
			trigger_error("Direct Instantiation of vB_DataManager_Picture class prohibited.", E_USER_ERROR);
		}

		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('picturedata_start')) ? eval($hook) : false;
	}

	function verify_extension(&$extension)
	{
		$extension = strtolower($extension);
		return true;
	}

	/**
	* Set the filehash/filesize of the file
	*
	* @param	integer	Maximum posts per page
	*
	* @return	boolean
	*/
	function verify_filedata(&$filedata)
	{
		if (strlen($filedata) > 0)
		{
			$this->set('filesize', strlen($filedata));
		}

		return true;
	}

	/**
	* Set the filesize of the thumbnail
	*
	* @param	integer	Maximum posts per page
	*
	* @return	boolean
	*/
	function verify_thumbnail(&$thumbnail)
	{
		if (strlen($thumbnail) > 0)
		{
			$this->set('thumbnail_filesize', strlen($thumbnail));
		}
		return true;
	}

	/**
	* Any code to run before deleting.
	*
	* @param	Boolean Do the query?
	*/
	function pre_delete($doquery = true)
	{
		@ignore_user_abort(true);

		return true;
	}

	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		if (!$this->fetch_field('idhash'))
		{
			$this->set('idhash', md5(TIMENOW . SESSION_IDHASH . SESSION_HOST . rand(1, 1000000)));
		}

		if (!$this->fetch_field('thumbnail_dateline'))
		{
			$this->set('thumbnail_dateline', TIMENOW);
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('picturedata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	function post_save_each($doquery = true)
	{
		$pictureid = intval($this->fetch_field('pictureid'));

		if (!$this->condition AND !empty($this->info['albums']))
		{
			$dateline = (!$this->info['dateline'] ? TIMENOW : $this->info['dateline']);

			$albuminsert = array();
			$albumids = array();
			foreach ($this->info['albums'] AS $album)
			{
				$albumids[] = intval($album['albumid']);
				$albuminsert[] = "(" . intval($album['albumid']) . ", $pictureid, $dateline)";
			}

			$this->registry->db->query_write("
				REPLACE INTO " . TABLE_PREFIX . "albumpicture
					(albumid, pictureid, dateline)
				VALUES " . implode(', ', $albuminsert)
			);

			if ($this->info['auto_count_update'])
			{
				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . "album SET
						picturecount = picturecount + 1,
						lastpicturedate = IF($dateline > lastpicturedate, $dateline, lastpicturedate)
					WHERE albumid IN (" . implode(',', $albumids) . ")
				");
			}
		}

		($hook = vBulletinHook::fetch_hook('picturedata_postsave')) ? eval($hook) : false;
		return parent::post_save_each($doquery);
	}

	function post_delete($doquery = true)
	{
		$albums = array();

		$albums_sql = $this->registry->db->query_read("
			SELECT album.*
			FROM " . TABLE_PREFIX . "albumpicture AS albumpicture
			INNER JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
			WHERE albumpicture.pictureid = " . $this->fetch_field('pictureid')
		);
		while ($album = $this->registry->db->fetch_array($albums_sql))
		{
			$albums[] = $album;
		}

		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "albumpicture
			WHERE pictureid = " . $this->fetch_field('pictureid')
		);

		if ($this->info['auto_count_update'] AND $albums)
		{
			foreach ($albums AS $album)
			{
				$albumdata =& datamanager_init('Album', $this->registry, ERRTYPE_SILENT);
				$albumdata->set_existing($album);
				$albumdata->rebuild_counts();
				if ($albumdata->fetch_field('coverpictureid') == $this->fetch_field('pictureid'))
				{
					if ($album['picturecount'] - 1 > 0)
					{
						$new_cover = $this->registry->db->query_first("
							SELECT pictureid
							FROM " . TABLE_PREFIX . "albumpicture
							WHERE albumid = $album[albumid]
							ORDER BY dateline ASC
							LIMIT 1
						");
					}

					$albumdata->set('coverpictureid', ($new_cover['pictureid'] ? $new_cover['pictureid']: 0));
				}
				$albumdata->save();
			}
		}

		$del_usercss = array();
		foreach ($albums AS $album)
		{
			$del_usercss[] = "'$album[albumid]," . $this->fetch_field('pictureid') . "'";
		}

		if ($del_usercss)
		{
			$this->registry->db->query_write("
				DELETE FROM " . TABLE_PREFIX . "usercss
				WHERE property = 'background_image'
					AND value IN (" . implode(',', $del_usercss) . ")
					AND userid = " . intval($this->fetch_field('userid')) . "
			");
			$this->info['have_updated_usercss'] = ($this->registry->db->affected_rows() > 0);
		}

		$groups = array();

		$groups_sql = $this->registry->db->query_read("
			SELECT DISTINCT socialgroup.*
			FROM " . TABLE_PREFIX . "socialgrouppicture AS socialgrouppicture
			INNER JOIN " . TABLE_PREFIX . "socialgroup AS socialgroup ON (socialgroup.groupid = socialgrouppicture.groupid)
			WHERE socialgrouppicture.pictureid = " . $this->fetch_field('pictureid')
		);
		while ($group = $this->registry->db->fetch_array($groups_sql))
		{
			$groups[] = $group;
		}

		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "socialgrouppicture
			WHERE pictureid = " . $this->fetch_field('pictureid')
		);

		foreach ($groups AS $group)
		{
			$groupdata =& datamanager_init('SocialGroup', $this->registry, ERRTYPE_SILENT);
			$groupdata->set_existing($group);
			$groupdata->rebuild_picturecount();
			$groupdata->save();
		}

		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "picturecomment
			WHERE pictureid = " . $this->fetch_field('pictureid')
		);

		require_once(DIR . '/includes/functions_picturecomment.php');
		build_picture_comment_counters($this->fetch_field('userid'));

		($hook = vBulletinHook::fetch_hook('picturedata_delete')) ? eval($hook) : false;
		return parent::post_delete($doquery);
	}
}

class vB_DataManager_Picture_Database extends vB_DataManager_Picture
{
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$parent = parent::pre_save($doquery);
		if (!$parent)
		{
			return $parent;
		}

		if (!empty($this->info['filedata']))
		{
			$this->setr('filedata', $this->info['filedata']);
		}
		if (!empty($this->info['thumbnail']))
		{
			$this->setr('thumbnail', $this->info['thumbnail']);
		}

		return true;
	}
}

class vB_DataManager_Picture_Filesystem extends vB_DataManager_Picture
{
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$parent = parent::pre_save($doquery);
		if (!$parent)
		{
			return $parent;
		}

		if (!empty($this->info['filedata']) OR !empty($this->info['thumbnail']))
		{
			require_once(DIR . '/includes/functions_album.php');

			$picture = array_merge($this->existing, $this->picture);
			$pic_path = verify_picture_fs_path($picture, false);
			$thumb_path = verify_picture_fs_path($picture, true);

			if (!$pic_path OR !$thumb_path)
			{
				$this->error('attachpathfailed');
				return false;
			}

			if (!is_writable($pic_path) OR !is_writable($thumb_path))
			{
				$this->error('upload_file_system_is_not_writable');
				return false;
			}
		}

		return true;

	}

	function post_save_each($doquery = true)
	{
		$failed = false;

		require_once(DIR . '/includes/functions_album.php');
		$picture = array_merge($this->existing, $this->picture);

		// Check for filedata in an information field
		if (!empty($this->info['filedata']))
		{
			$filename = fetch_picture_fs_path($picture);
			if ($fp = fopen($filename, 'wb'))
			{
				if (!fwrite($fp, $this->info['filedata']))
				{
					$failed = true;
				}
				fclose($fp);

				#remove possible existing thumbnail in case no thumbnail is written in the next step.
				$thumb_path = fetch_picture_fs_path($picture, true);
				if (file_exists(!$thumb_path))
				{
					@unlink($thumb_path);
				}
			}
			else
			{
				$failed = true;
			}
		}

		if (!$failed AND !empty($this->info['thumbnail']))
		{
			// write out thumbnail now
			$filename = fetch_picture_fs_path($picture, true);
			if ($fp = fopen($filename, 'wb'))
			{
				if (!fwrite($fp, $this->info['thumbnail']))
				{
					$failed = true;
				}
				fclose($fp);
			}
			else
			{
				$failed = true;
			}
		}

		parent::post_save_each($doquery);

		if ($failed)
		{
			if ($this->condition === null) // Insert, delete attachment
			{
				$this->condition = "pictureid = " . $this->fetch_field('pictureid');
				$this->log = false;
				$this->delete();
			}

			// $php_errormsg is automatically set if track_vars is enabled
			return false;
		}
		else
		{
			return true;
		}
	}

	/**
	* Any code to run after deleting
	*
	* @param	Boolean Do the query?
	*/
	function post_delete($doquery = true)
	{
		require_once(DIR . '/includes/functions_album.php');
		$picture = array_merge($this->existing, $this->picture);

		@unlink(fetch_picture_fs_path($picture));
		@unlink(fetch_picture_fs_path($picture, true));

		return parent::post_delete($doquery);
	}
}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 25445 $
|| ####################################################################
\*======================================================================*/
?>
